<?php
/*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class TextBanner extends ObjectModel
{
	public $title;
	public $url;
	public $legend;
	public $active;
	public $position;

	public $icon;
	public $icon_bg;
	public $icon_c;
	public $title_c;
	public $label_c;

	/**
	 * @see ObjectModel::$definition
	 */
	public static $definition = array(
		'table' => 'textbanners_banners',
		'primary' => 'id_textbanners_banners',
		'multilang' => true,
		'fields' => array(
			'active' =>			array('type' => self::TYPE_BOOL, 'validate' => 'isBool', 'required' => true),
			'position' =>		array('type' => self::TYPE_INT, 'validate' => 'isunsignedInt', 'required' => true),
			'icon' =>			array('type' => self::TYPE_STRING, 'validate' => 'isGenericName'),
			'icon_bg' =>		array('type' => self::TYPE_STRING, 'validate' => 'isColor'),
			'icon_c' =>			array('type' => self::TYPE_STRING, 'validate' => 'isColor'),
			'title_c' =>		array('type' => self::TYPE_STRING, 'validate' => 'isColor'),
			'label_c' =>		array('type' => self::TYPE_STRING, 'validate' => 'isColor'),

			// Lang fields
			'title' =>			array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'required' => true, 'size' => 255),
			'legend' =>			array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCleanHtml', 'required' => true, 'size' => 255),
			'url' =>			array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isUrl', 'size' => 255),
		)
	);

	public	function __construct($id_banner = null, $id_lang = null, $id_shop = null, Context $context = null)
	{
		parent::__construct($id_banner, $id_lang, $id_shop);
	}

	public function add($autodate = true, $null_values = false)
	{
		$context = Context::getContext();
		$id_shop = $context->shop->id;

		$res = parent::add($autodate, $null_values);
		$res &= Db::getInstance()->execute('
			INSERT INTO `'._DB_PREFIX_.'textbanners` (`id_shop`, `id_textbanners_banners`)
			VALUES('.(int)$id_shop.', '.(int)$this->id.')'
		);
		return $res;
	}

	public function delete()
	{
		$res = true;


		$res &= $this->reOrderPositions();

		$res &= Db::getInstance()->execute('
			DELETE FROM `'._DB_PREFIX_.'textbanners`
			WHERE `id_textbanners_banners` = '.(int)$this->id
		);

		$res &= parent::delete();
		return $res;
	}

	public function reOrderPositions()
	{
		$id_banner = $this->id;
		$context = Context::getContext();
		$id_shop = $context->shop->id;

		$max = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT MAX(hss.`position`) as position
			FROM `'._DB_PREFIX_.'textbanners_banners` hss, `'._DB_PREFIX_.'textbanners` hs
			WHERE hss.`id_textbanners_banners` = hs.`id_textbanners_banners` AND hs.`id_shop` = '.(int)$id_shop
		);

		if ((int)$max == (int)$id_banner)
			return true;

		$rows = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT hss.`position` as position, hss.`id_textbanners_banners` as id_banner
			FROM `'._DB_PREFIX_.'textbanners_banners` hss
			LEFT JOIN `'._DB_PREFIX_.'textbanners` hs ON (hss.`id_textbanners_banners` = hs.`id_textbanners_banners`)
			WHERE hs.`id_shop` = '.(int)$id_shop.' AND hss.`position` > '.(int)$this->position
		);

		foreach ($rows as $row)
		{
			$current_banner = new TextBanner($row['id_banner']);
			--$current_banner->position;
			$current_banner->update();
			unset($current_banner);
		}

		return true;
	}

}
