<?php
if (!defined('_PS_VERSION_'))
    exit;

require_once('classes/class.ventiappapi.php');

class Ventiapp extends Module
{
    public function __construct()
    {
        $this->name = 'ventiapp';
        $this->tab = 'content_management';
        $this->version = '1.0.2';
        $this->author = 'kubodigital.com';
        $this->need_instance = 0;
        $this->dir = '/modules/ventiapp/';
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->bootstrap = true;

        $this->venti_api_service = "https://app.ventiapp.com/notification/prestashopnotification/";



        parent::__construct();

        $this->displayName = $this->l('Ventiapp');
        $this->description = $this->l('This module help you to integrate all data info into Ventiapp platform. Powered by Ventiapp & developed by kubodigital.com');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');

        if (!Configuration::get('API_KEY'))
            $this->warning = $this->l('No name provided');

        //API STATUS TO BE NOTIFIED
        if (!Configuration::get('API_STATUS'))
            $this->warning = $this->l('No name provided');

        //API STATUS TO BE NOTIFIED
        //if (!Configuration::get('STATUS_IDS'))
        //    $this->warning = $this->l('No name provided');
    }

    public function install()
    {
 
        if(!$this->installDb())
            return false;


        $status_default = 'payment,bankwire,cashondelivery';
        Configuration::updateValue('API_STATUS', $status_default);

        return parent::install() &&
            $this->registerHook('actionOrderStatusUpdate') &&
            $this->registerHook('displayOrderConfirmation') &&
            $this->registerHook('actionUpdateQuantity')  ;


    }

    public function uninstall()
    {
        if(!$this->uninstallDb())
            return false;

        if (!parent::uninstall() ||
            !Configuration::deleteByName('API_KEY') || !Configuration::deleteByName('API_STATUS')
        ) return false;

        return true;
    }


    /*
     *CONFIG FORM
     */

    public function getContent()
    {
        $output = null;

        if (Tools::isSubmit('submit'.$this->name))
        {
            $my_apy_key    = strval(Tools::getValue('API_KEY'));
            $my_apy_status = strval(Tools::getValue('API_STATUS'));

            if (!$my_apy_key
                || empty($my_apy_key)
                || !Validate::isGenericName($my_apy_key))
                $output .= $this->displayError($this->l('Invalid Configuration value'));
            else
            {
                Configuration::updateValue('API_KEY', $my_apy_key);
                Configuration::updateValue('API_STATUS', $my_apy_status);
                $output .= $this->displayConfirmation($this->l('Settings updated'));
            }
        }

        //SMARTY PATH
        $this->context->smarty->assign(array(
            'module_dir' => $this->_path,
            'module_local_dir' => $this->local_path,
        ));

        //INFO TEMPLATE
        $output = $output.$this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');

        return $output.$this->displayForm();
    }

    public function displayForm()
    {
        // Get default language
        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');



        // Init Fields form array
        $fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('Settings'),
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('API KEY'),
                    'name' => 'API_KEY',
                    'desc' => 'Deberas solicitar una API KEY al equipo de Ventiapp',
                    'size' => 256,
                    'required' => true
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('STATUS DE INFORME'),
                    'name' => 'API_STATUS',
                    'desc' => 'Ingresa los diferentes status separados por coma que se notificarán en Ventiapp',
                    'size' => 256,
                    'required' => true
                )

            ),
            'submit' => array(
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right'
            )
        );

        $helper = new HelperForm();

        // Module, token and currentIndex
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        // Language
        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;

        // Title and toolbar
        $helper->title = $this->displayName;
        $helper->show_toolbar = true;        // false -> remove toolbar
        $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
        $helper->submit_action = 'submit'.$this->name;
        $helper->toolbar_btn = array(
            'save' =>
                array(
                    'desc' => $this->l('Save'),
                    'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
                        '&token='.Tools::getAdminTokenLite('AdminModules'),
                ),
            'back' => array(
                'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
                'desc' => $this->l('Back to list')
            )
        );

        // Load current value
        $helper->fields_value['API_KEY'] = Configuration::get('API_KEY');
        $helper->fields_value['API_STATUS'] = Configuration::get('API_STATUS');

        return $helper->generateForm($fields_form);
    }

    /**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitLiniosyncModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm()));
    }


    public function hookActionOrderStatusUpdate($params)
    {
        $apiKey = (string) Configuration::get('API_KEY');
        $apiStatus = (string) Configuration::get('API_STATUS');

        $statusToVenti = explode(',', $apiStatus);
        $order_status  = $params["newOrderStatus"]->template ;

        //IF STATUS MATCH CALL SERVICE TO INFORM VENTIAPP
        foreach ($statusToVenti as $stat) {
            if (strpos($order_status, $stat) !== FALSE) {

                (object) $order_venti = array(
                    'type'=>"venta",
                    'hash_empresa'=> $apiKey,
                    'payload'=> (object) array('venti_ext' => $params["id_order"], 'id_shop' => 1)

                );

                $mensaje = "VENTIAPI - ORDER - LLAMANDO " .json_encode($order_venti)   ;
                PrestaShopLoggerCore::addLog($mensaje,1);

                $api = new VentiappApi();
                $body = json_encode($order_venti);
                //CALLAPI REST by POST
                $datos = $api->CallAPI("POST",$this->venti_api_service,$body);

                //LOG DATABASE
                $arr[] = array(
                    'venti_ext' => $params["id_order"],
                    'id_shop' => 1
                );
                if (isset($arr)) {
                    Db::getInstance()->insert('venti_orders_sync', $arr, false);
                }

                //LOGGER
                $mensaje = "VENTIAPI - ORDER  - RESPUESTA" .json_encode($datos)   ;
                PrestaShopLoggerCore::addLog($mensaje,1);
                return true;
            }
        }
    }



    //HOOK WHEN ORDER CONFIRMATIONN PAGE
    public function hookDisplayOrderConfirmation($params)
    {
       // var_dump($params);
    }

    //UPDATE PRODUCT IF CHANGE STOCK
    public function hookActionProductUpdate($params)
    {
        //var_dump($params);
        PrestaShopLoggerCore::addLog("actualizo todo el producto ",1);

    }


    //UPDATE PRODUCTO STOCK
    public function hookActionUpdateQuantity($params)
    {

        $apiKey = (string) Configuration::get('API_KEY');
        $id_cart = $params["cart"]->id;


        //CARRO NULO ACTUALIZACION DESDE BACKEND
        //HAY QUE LLAMAR A VENTIAPP POR QUE ACTUALIZARON STOCK A MANO
        if($id_cart == null){

            $var_data = json_encode($id_cart);

            $mensaje_1= "PRODUCTO - ACTUALIZADO - BACKEND"  ;
            PrestaShopLoggerCore::addLog($mensaje_1,1);


            //PRODUCTO ID Y PRODUCTO ATRIBUTO
            //VEAMOS SI TIENE VARIACION
            $product_id = $params["id_product"];
            $id_product_att  = $params["id_product_attribute"];

            //ARMO EL PRODUCTO CON EL ID
            $product = new Product($product_id,false);
            $canAtt = $product->hasAttributes();

            if($canAtt == 0){ // NO VARIACION

                //LLAMAR AL VENTI APP ASI NOMAS - NO TIENE VARIACION


                $prod_sku      = $product->reference ; //REFERENCE PARA PRODUCTO PLANO
                $prod_quantity = $params['quantity']  ; //FIRST POSITION

                (object) $stock_venti = array(
                    'type'=>"stock",
                    'hash_empresa'=> $apiKey,
                    'payload'=> (object) array('prod_sku' => $prod_sku, 'venti_ext' => $product_id , 'venti_ext_var'=> 0, 'prod_has_variation'=> false, 'prod_quantity'=> $prod_quantity, 'id_shop' => 1)

                );

                //HACER EL CALL AL SERVICIO

                $api = new VentiappApi();
                $body = json_encode($stock_venti);
                //CALLAPI REST by GET
                $datos = $api->CallAPI("POST",$this->venti_api_service,$body);

                $mensaje_6 = "VENTIAPI - STOCK  PLANO ACT - " . json_encode($datos)   ;
                PrestaShopLoggerCore::addLog($mensaje_6,1);


            }else{
                //CON VARIACION
                //OBTENGO LA VARIACION Y LLAMO EN EL SEGUNDA ITERACION

                if($id_product_att != 0){

                    $product_comb = $product->getAttributeCombinationsById($id_product_att);

                    $prod_quantity  = StockAvailable::getQuantityAvailableByProduct($product_id,$id_product_att); //FIRST POSITION; //FIRST POSITION
                    $prod_sku      = $product_comb[0]["reference"];

                    (object) $stock_venti = array(
                        'type'=>"stock",
                        'hash_empresa'=> $apiKey,
                        'payload'=> (object) array('prod_sku' => $prod_sku, 'venti_ext' => $product_id , 'venti_ext_var'=> $id_product_att, 'prod_has_variation'=> true, 'prod_quantity'=> $prod_quantity, 'id_shop' => 1)

                    );

                    //HACER EL CALL AL SERVICIO

                    $api = new VentiappApi();
                    $body = json_encode($stock_venti);
                    //CALLAPI REST by GET
                    $datos = $api->CallAPI("POST",$this->venti_api_service,$body);

                    $mensaje_7 = "VENTIAPI - STOCK COMBINADO_ACT - " . json_encode($datos)   ;
                    PrestaShopLoggerCore::addLog($mensaje_7,1);

                }

            }




        }else{

            //PRODUCTO IGNORADO DESDE CART
            $mensaje_exclude = "PRODUCTO - IGNORADO - CART" ;
            PrestaShopLoggerCore::addLog($mensaje_exclude,1);

        }


    }

    //UPDATE PRODUCT IF STOCK CHANGE
    public function hookActionProductAttributeUpdate($params)
    {
        //var_dump($params);

    }



    public function installDb()
    {
        $sql_file = dirname(__FILE__).'/sql/install.sql';

        $sql_content = file_get_contents($sql_file);

        $sql_content = str_replace('PREFIX_',_DB_PREFIX_,$sql_content);
        $sql_requests = preg_split("/;\s*[\r\n]+/",$sql_content);

        $result = true;
        foreach ($sql_requests as $request)
            if(!empty($request))
                $result &= Db::getInstance()->execute(trim($request));

        return $result;
    }

    public function uninstallDb()
    {
        $sql_file = dirname(__FILE__).'/sql/uninstall.sql';

        $sql_content = file_get_contents($sql_file);

        $sql_content = str_replace('PREFIX_',_DB_PREFIX_,$sql_content);
        $sql_requests = preg_split("/;\s*[\r\n]+/",$sql_content);

        $result = true;
        foreach ($sql_requests as $request)
            if(!empty($request))
                $result &= Db::getInstance()->execute(trim($request));

        return $result;
    }





}