<?php
/**
* Modulo Kueski
*
* @author    Lievant
* @copyright 2020 Lievant
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*/

/**
 * the name of the class should be [ModuleName][ControllerName]ModuleFrontController
 */
class KueskiRedirectModuleFrontController extends ModuleFrontController
{
    private $gateway;
    private $config;
    private $paymentDetails;
    private $items = array();
    private $itemTotalValue = 0;
    private $taxTotalValue = 0;
    private $itemDiscountValue = 0;
    private $isFreeShipping = false;
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->gateway = $this->module->gateway;
        $this->config = $this->module->gateway->config;
        $this->settings = $this->gateway->getSettings();
    }
    
    private function getAddress($cart, $is_shipping = true)
    {
        $customer = $this->context->customer;
        $id_address = $is_shipping?(int)$cart->id_address_delivery:(int)$cart->id_address_invoice;
        if ($id_address == 0 && $customer) {
            $id_address = Address::getFirstCustomerAddressId($customer->id);
        }
        if (!$id_address) {
            return false;
        }
        $address = new Address($id_address);
        $state = '';
        if ($address->id_state) {
            $state = new State((int) $address->id_state);
        }
        if (!(int)$address->id_country) {
            return false;
        }
        $country = new Country((int)$address->id_country);
        $address_kueski = new stdClass;
        $address_kueski->name = new stdClass;
        $address_kueski->address = new stdClass;
        $address_kueski->name->name = $address->firstname;
        $address_kueski->name->last = $address->lastname;
        $address_kueski->address->city = $address->city;
        $address_kueski->address->address = $address->address1;
        $address_kueski->address->interior = $address->address2;
        $address_kueski->address->state = $state->name;//$state ? $state->iso_code : $state->name;
        $address_kueski->address->zipcode = $address->postcode;
        $address_kueski->address->country = $country->iso_code;
        $address_kueski->phone_number = (empty($address->phone)) ? $address->phone_mobile : $address->phone;
        $address_kueski->email = $customer->email;
        if ($is_shipping) {
            $address_kueski->type = 'HOME';
        }
        return $address_kueski;
    }
    private function getProductsList($cart, $currency)
    {
        $products = $cart->getProducts();
        foreach ($products as $product) {
            $pname = $product['name'];
            $product['product_tax'] = $product['price_wt'] - $product['price'];
            if (isset($product['attributes']) && (empty($product['attributes']) === false)) {
                $product['name'] .= ' - '.$product['attributes'];
            }
            $item = new stdClass;
            $item->name = $pname;
            $item->description = $product['name'];
            $item->currency = $currency;
            $item->sku = empty($product['reference'])?$product['ean13']:$product['reference'];
            $item->quantity = (int)$product['quantity'];
            $item->tax = $this->formatPrice($product['product_tax'], 4) * $item->quantity;
            $item->price = 1*$this->formatPrice($product['price']);
            $this->items[] = $item;
            $this->itemTotalValue += $item->price * $item->quantity;
            $this->taxTotalValue += $item->tax;// * $item->quantity;
        }
    }
    private function getDiscountsList($cart, $currency)
    {
        $discounts = $cart->getCartRules();
        if (count($discounts) > 0) {
            foreach ($discounts as $discount) {
                if (isset($discount['description']) && !empty($discount['description'])) {
                    $discount['description'] = Tools::substr(strip_tags($discount['description']), 0, 50).'...';
                } else {
                    $discount['description'] = 'Cupon';
                }
                $discount['value_real'] = -1 * $discount['value_real'];
                $item = new stdClass;
                $item->name = $discount['name'];
                $item->description = $discount['name'];
                $item->currency = $currency;
                $item->quantity = 1;
                $item->sku = 'Cupon';
                $item->tax = 0;
                if ($discount['free_shipping']) {
                    $this->isFreeShipping = true;
                    $shipping_cost_wt = $cart->getTotalShippingCost();
                    $discount['value_real'] += $shipping_cost_wt;
                }
                $item->price = 1*$this->formatPrice($discount['value_real']);
                $this->itemDiscountValue += $discount['value_real'];
                //$this->items[] = $item;
            }
        }
    }
    private function getGiftWrapping($cart, $currency)
    {
        $wrapping_price = $cart->gift ? $cart->getGiftWrappingPrice() : 0;
        if ($wrapping_price > 0) {
            $wrapping_price = $wrapping_price;
            $item = new stdClass;
            $item->name = $this->l('Gift wrapping');
            $item->description = $this->l('Gift wrapping');
            $item->currency = $currency;
            $item->sku = 'Gift';
            $item->quantity = 1;
            $item->tax = 0;
            $item->price = 1*$this->formatPrice($wrapping_price);
            $this->items[] = $item;
            $this->itemTotalValue += $wrapping_price;
        }
    }
    public function formatPrice($price, $decimals = 2, $context_currency = null)
    {
        if ($context_currency === null) {
            $context_currency = $this->context->currency;
        }
        $module_currency = new Currency(Currency::getIdByIsoCode($this->settings['CURRENCY']));
        if ($context_currency->id != $module_currency->id) {
            $price = Tools::convertPrice($price, $module_currency, false);
        }
        $price = number_format($price, $decimals, ".", '');
        return $price;
    }
    public function setAttributesButton($cart, $order) {
        $module_currency = new Currency(Currency::getIdByIsoCode($this->settings['CURRENCY']));
        $currency = $module_currency->iso_code;
        $this->getProductsList($cart, $currency);
        $this->getGiftWrapping($cart, $currency);
        $this->getDiscountsList($cart, $currency);
        $shipping_cost_wt = $this->formatPrice($cart->getTotalShippingCost());
        $shipping = $this->isFreeShipping?0:$shipping_cost_wt;
        $total_tax = $this->taxTotalValue;
        $subtotal = $this->itemTotalValue;// + $this->formatPrice($this->itemDiscountValue);
        $total = $shipping + $subtotal + $total_tax + $this->formatPrice($this->itemDiscountValue);
        $products = $cart->getProducts();
        try {
            if (!$this->gateway->verifyKueski() ||
                !$this->gateway->api_me ||
                !isset($this->gateway->api_me['data']['merchant_limits']) || 
                $total < $this->gateway->api_me['data']['merchant_limits']['min_amount'] || 
                $total > $this->gateway->api_me['data']['merchant_limits']['max_amount']) {
                    throw \Exception('Monto fuera de los limites '.print_r($this->gateway->api_me, true));
            }
            $status_act = $this->gateway->os_wait_payment;
            $customer = new Customer((int)$cart->id_customer);
            $this->module->validateOrder(
                $cart->id,
                $status_act,
                $cart->getOrderTotal(true, Cart::BOTH),
                'Kueski Pay',
                false,
                array(),
                (int)$cart->id_currency,
                false,
                $customer->secure_key
            );
            $id_order = (int)Order::getOrderByCartId($cart->id);
            $return_url_ok = Context::getContext()->link->getModuleLink($this->module->name, 'redirect', array(
                'result' => 'ok',
                'id_order' => $id_order
            ));
            $return_url_error = Context::getContext()->link->getModuleLink($this->module->name, 'redirect', array(
                'result' => 'error',
                'id_order' => $id_order
            ));
            $is_first_item = true;
            $additional_info = '';
            foreach ($products as &$p) {
                if ($is_first_item) {
                    $is_first_item = false;
                    $additional_info .= $p['name'].'('.$p['quantity'].' U.)';
                } else {
                    $additional_info .= ' - '.$p['name'].'('.$p['quantity'].' U.)';
                }
                if (isset($p['attributes']) && !empty($p['attributes'])) {
                    $additional_info .= ', '.str_replace('-', ',', $p['attributes']);
                }
            }
            $data = array(
                'description' => 'Orden Nro '.$id_order,
                'order_id' => $id_order,
                'callbacks' => array(
                    'on_success' => $return_url_ok,
                    'on_reject' => $return_url_error,
                    'on_canceled' => $return_url_error,
                    'on_failed' => $return_url_error
                ),
                "items" => $this->items,
                "shipping" => $this->getAddress($cart, true),
                "billing" => $this->getAddress($cart, false),
                "amount" => array(
                    'total' => (float)$total,
                    "currency" => $currency,
                    "details" => array(
                        'subtotal' => (float)$subtotal,
                        'shipping' => (float)$shipping,
                        'tax' => (float)$total_tax,
                        "handling_fee" => (float)$this->formatPrice($this->itemDiscountValue),
                    )
                ),
            );
            //echo (json_encode($data));
            //KueskiGateway::log("createOrder: ".print_r($data, true));
            $r = $this->gateway->api->createOrder($data);
            KueskiGateway::log("createOrder result: ".print_r($r['data']->payment_id, true));
            Db::getInstance()->execute('INSERT INTO `'.bqSQL(_DB_PREFIX_.KueskiGateway::DB_PREFIX).'`
                (
                    `id_order`,
                    `id_cart`,
                    `id_shop`,
                    `is_sandbox`,
                    `status`,
                    `order_reference`,
                    `max_wait`,
                    `next_retry`
                ) VALUES (
                    '.(int)$id_order.',
                    '.(int)$cart->id.',
                    '.(int)$cart->id_shop.',
                    '.(int)$this->config['sandbox'].',
                    '.(int)$this->gateway->os_wait_payment.',
                    \''.pSQL($r['data']->payment_id).'\',
                    '.(time() + 3 * 24 * 60 * 60).',
                    '.(time()).'
                )');
        } catch (Exception $e) {
            KueskiGateway::log("Exception result: ".$e->getFile().'['.$e->getLine().']: '.$e->getMessage().print_r($r, true));
            if ($this->config['modal']) {
                echo '<html><body><script>
                        if (typeof window.opener != "undefined" && typeof window.opener.location != "undefined") {
                            window.opener.location.href = "'.__PS_BASE_URI__.'index.php?controller=order";
                            setTimeout(function(){window.close();}, 200);
                        } else {
                            window.location.href = "'.__PS_BASE_URI__.'index.php?controller=order";
                        }
                      </script></body></html>';
                exit;
            } else {
                Tools::redirect('index.php?controller=order');
            }
        }
        return $r['url'];
    }
    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        parent::initContent();
        if (!isset($this->module->gateway) || !$this->module->gateway || !$this->module->active) {
            Tools::redirect('index');
            exit;
        }
        $phpinput = file_get_contents("php://input");
        //KueskiGateway::log("Redirect\n\nGET: ".print_r($_GET, true)."\n\nPOST:".print_r($_POST, true)."\n\nPHPINPUT:".$phpinput);
        if ($phpinput && !empty($phpinput)) {
            $input = json_decode($phpinput, true);
            if (isset($input['order_id'])) {
                $order = new Order($input['order_id']);
                $currency = new Currency($order->id_currency);
                if (abs($this->formatPrice($order->total_paid, 2, $currency) - $input['amount']) > 1.0) {
                    $order->setCurrentState((int)$this->config['os_refused']);
                    KueskiGateway::log("Result: 'reject' 1 > ".$this->formatPrice($order->total_paid, $currency).' - '.$input['amount']);
                    Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.KueskiGateway::DB_PREFIX).'`
                        SET
                            `next_retry` = '.(int)(time()).',
                            `status` = '.(int)$order->getCurrentState().'
                        WHERE id_order = '.(int)$order->id);
                    $this->gateway->api->confirmWebhook(array('status' => 'reject', 'error' => 'Incorrect Amount'));
                }
                if ($input['status'] == 'approved') {
                    $order->setCurrentState((int)$this->config['os_authorization']);
                    KueskiGateway::log("Result: 'accept'");
                    Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.KueskiGateway::DB_PREFIX).'`
                        SET
                            `next_retry` = '.(int)(time()).',
                            `status` = '.(int)$order->getCurrentState().'
                        WHERE id_order = '.(int)$order->id);
                    $this->gateway->api->confirmWebhook(array('status' => 'accept', 'error' => ''));
                }
                $order->setCurrentState((int)$this->config['os_refused']);
                KueskiGateway::log("Result: 'reject' 2 {$input['status']}");
                    Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.KueskiGateway::DB_PREFIX).'`
                        SET
                            `next_retry` = '.(int)(time()).',
                            `status` = '.(int)$order->getCurrentState().'
                        WHERE id_order = '.(int)$order->id);
                $this->gateway->api->confirmWebhook(array('status' => 'reject', 'error' => 'Incorrect status '.$input['status']));
            }
            exit;
        }
        if (Tools::isSubmit('result')) {
            if ((int)Tools::getValue('id_order') > 0) {
                $order = new Order((int)Tools::getValue('id_order'));
                $cart = new Cart((int)$order->id_cart);
                if (!$cart || $cart->getOrderTotal(true, Cart::BOTH) < 0.1) {
                    Tools::redirect('index');
                    exit;
                }
                if (Tools::getValue('result') == 'error') {
                    $duplication = $cart->id_customer == $this->context->customer->id?$cart->duplicate():false;
                    $url = 'index.php?controller=order';
                    if (!$duplication || !Validate::isLoadedObject($duplication['cart'])) {
                        $url = 'index.php';
                    } else {
                        $cart = $duplication['cart'];
                        $this->context->cart = $cart;
                        $customer = new Customer($cart->id_customer);
                        $this->context->customer = $customer;
                        CartRule::autoRemoveFromCart();
                        CartRule::autoAddToCart();
                        $this->context->cookie->id_customer = $cart->id_customer;
                        $this->context->cookie->id_cart = $cart->id;
                        $this->context->cookie->id_currency = $cart->id_currency;
                        $this->context->cookie->id_lang = $cart->id_lang;
                        $this->context->cookie->id_guest = $cart->id_guest;
                        if ($this->context->customer && $this->context->customer->id > 0) {
                            $this->context->cookie->is_guest = $this->context->customer->isGuest();
                        }
                        $this->context->cookie->write();
                    }
                    if ($this->config['modal']) {
                        echo '<html><body><script>
                                if (typeof window.opener != "undefined" && window.opener != null && typeof window.opener.location != "undefined") {
                                    window.opener.location.href = "'.__PS_BASE_URI__.$url.'";
                                    setTimeout(function(){window.close();}, 5000);
                                } else {
                                    window.location.href = "'.$url.'";
                                }
                              </script></body></html>';
                    } else {
                        Tools::redirect($url);
                    }
                    exit;
                }
                $customer = new Customer((int)$cart->id_customer);
                if ($this->config['modal']) {
                    echo '<html><body><script>
                            if (typeof window.opener != "undefined" && window.opener != null && typeof window.opener.location != "undefined") {
                                window.opener.location.href = "'.__PS_BASE_URI__.'index.php?controller=order-confirmation&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.$order->id.'&key='.$customer->secure_key.'";
                                setTimeout(function(){window.close();}, 5000);
                            } else {
                                window.location.href = "'.__PS_BASE_URI__.'index.php?controller=order-confirmation&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.$order->id.'&key='.$customer->secure_key.'";
                            }
                          </script></body></html>';
                    exit;
                } else {
                    Tools::redirect('index.php?controller=order-confirmation&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.$order->id.'&key='.$customer->secure_key);
                }
            } else {
                Tools::redirect('index.php?controller=order');
            }
        }
        if (Tools::isSubmit('createOrder')) {
            $action = $this->setAttributesButton($this->context->cart, false);
            if ($this->config['modal']) {
                $cart = $this->context->cart;
                $customer = new Customer((int)$cart->id_customer);
                Tools::redirect('index.php?controller=order-confirmation&show_modal='.urlencode($action).'&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.$order->id.'&key='.$customer->secure_key);
                exit;
            }
            header('Location: '.$action);
            exit;
        }
        echo 'OK';
        exit;
    }
}
