<?php
/**
* Modulo Kueski
*
* @author    Lievant
* @copyright 2020 Lievant
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*/

class KueskiGateway
{
    //Constantes
    const DB_PREFIX = 'kueski';

    //Configuracion general del modulo
    private $settings = null;
    public $config = null;
    public $os_wait_payment = null;
    private $currency_convert = array();
    private $site_id = null;
    private $site_url = null;
    private $id_shop = null;
    private $id_shop_group = null;
    private $module_name = null;
    private $instance_module = null;
    public $api = null;
    public $api_me = null;
    private $context = null;
    public $warning = '';

    //Propiedades estaticas
    private static $instance = null;
    private static $instance_status = 'uninstance';
    private static $mp_cache = array();
    private static $ignore_update_status = false;

    private function __construct($load_site_id, $load_module_name, $load_instance_module)
    {
        if (!defined('_PS_VERSION_')) {
            exit;
        }
        $data = include(dirname(__FILE__).'/data-mp-countries.php');
        $this->context = Context::getContext();
        $this->site_id = $load_site_id;
        $this->module_name = $load_module_name;
        $this->instance_module = $load_instance_module;
        $this->settings = $data[Tools::strtoupper($this->site_id)];
        $this->site_url = Tools::htmlentitiesutf8(
            ((bool)Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://')
            .$_SERVER['HTTP_HOST'].__PS_BASE_URI__
        );
        self::$instance = $this;
        if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
            $this->id_shop = Shop::getContextShopID();
            $this->id_shop_group = Shop::getContextShopGroupID();
            if ((int)$this->id_shop > 0) {
                $shop = new Shop($this->id_shop);
                $this->site_url = (bool)Configuration::get('PS_SSL_ENABLED')?'https://'.$shop->domain_ssl:'http://'
                                    .$shop->domain;
                $this->site_url .= $shop->getBaseURI(true);
            }
            $config2 = Configuration::get(
                $this->module_name.'ksk_config',
                null,
                $this->id_shop_group,
                $this->id_shop
            );
            $this->config = (array)Tools::jsonDecode($config2, true);
            $this->currency_convert = (array)Tools::jsonDecode(Configuration::get(
                $this->module_name.'kijam_currency_convert',
                null,
                $this->id_shop_group,
                $this->id_shop
            ), true);
            $this->os_wait_payment = (int)Configuration::get(
                $this->module_name.'kijam_os_wait_payment',
                null,
                $this->id_shop_group,
                $this->id_shop
            );
        } else {
            $this->config = (array)Tools::jsonDecode(Configuration::get($this->module_name.'ksk_config'), true);
            $this->os_wait_payment = (int)Configuration::get($this->module_name.'kijam_os_wait_payment');
        }
        if (isset($this->config['client_id']) && isset($this->config['client_secret'])) {
            if (!class_exists('KueskiLib')) {
                include(dirname(__file__).'/lib/KueskiLib.php');
            }
            $ksource = $this->context->isMobile() ? "mobile" : "web";
            $this->api = new KueskiLib(
                $this->config['client_id'],
                $this->config['client_secret'],
                $this->module_name.'_prestashop',
                'v'.$this->instance_module->version,
                'checkout_button',
                $ksource,
                (bool)$this->config['sandbox']
            );
            $this->verifyOrderWaitStatus();
            $this->verifyKueski();
            if ($this->api_me) {
                if ($this->api_me['status'] == 'fail') {
                    $this->api_me = null;
                    $this->api = null;
                }
            }
            if (!isset($this->config['client_id'])) {
                $this->config['os_authorization'] = (int)Configuration::get('PS_OS_PAYMENT');
                $this->config['os_refused'] = (int)Configuration::get('PS_OS_ERROR');
                $this->config['preorder'] = true;
                $this->config['sandbox'] = false;
            }
        }
        if (!isset($this->config['style']) || !isset($this->config['style']['b_size'])) {
            $this->config['style'] = array(
                'b_size' => 'M',
            );
        }
    }
    public static function getCartOrderTotal($cart = null)
    {
        static $running = false;
        static $cache = array();
        if ($cart === null) {
            $cart = Context::getContext()->cart;
        }
        if (isset($cache[$cart->id])) {
            return $cache[$cart->id];
        }
        if ($running) {
            return array(
                'both' => 0.0,
                'products' => 0.0,
                'shipping' => 0.0
            );
        }
        $running = true;
        $wrapps = $cart->getOrderTotal(true, Cart::ONLY_WRAPPING);
        $discounts = $cart->getOrderTotal(true, Cart::ONLY_DISCOUNTS);
        $products = $cart->getOrderTotal(true, Cart::ONLY_PRODUCTS);
        $wrapps_without_tax = $cart->getOrderTotal(false, Cart::ONLY_WRAPPING);
        $discounts_without_tax = $cart->getOrderTotal(false, Cart::ONLY_DISCOUNTS);
        $products_without_tax = $cart->getOrderTotal(false, Cart::ONLY_PRODUCTS);
        $cache[$cart->id] = array(
            'both' => $cart->getOrderTotal(true, Cart::BOTH),
            'discounts' => $discounts,
            'wrapps' => $wrapps,
            'products_full' => $products,
            'products' => $products + $wrapps - $discounts,
            'both_without_tax' => $cart->getOrderTotal(false, Cart::BOTH),
            'discounts_without_tax' => $discounts_without_tax,
            'wrapps_without_tax' => $wrapps_without_tax,
            'products_full_without_tax' => $products_without_tax,
            'products_without_tax' => $products_without_tax + $wrapps_without_tax - $discounts_without_tax,
        );
        $cache[$cart->id]['tax'] = $cache[$cart->id]['both'] - $cache[$cart->id]['both_without_tax'];
        $cache[$cart->id]['shipping'] = $cache[$cart->id]['both'] - $cache[$cart->id]['products'];
        $cache[$cart->id]['shipping_without_tax'] = $cache[$cart->id]['both_without_tax'] - $cache[$cart->id]['products_without_tax'];
        $running = false;
        return $cache[$cart->id];
    }
    public static function getInstance($load_site_id, $load_module_name, $load_instance_module)
    {
        if (is_null(self::$instance) && self::$instance_status == 'uninstance') {
            self::$instance_status = 'loading';
            self::$instance = new KueskiGateway($load_site_id, $load_module_name, $load_instance_module);
            self::$instance_status = 'loaded';
        }
        return self::$instance;
    }
    public function installDb()
    {
         $db_created = Db::getInstance()->Execute('CREATE TABLE IF NOT EXISTS `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'` (
                `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                `id_order` INT(11) DEFAULT NULL,
                `id_cart` INT(11) DEFAULT NULL,
                `id_shop` INT(11) NOT NULL,
                `is_sandbox` TINYINT(1) NOT NULL DEFAULT 0,
                `status` varchar(100) NOT NULL,
                `order_reference` varchar(255) NOT NULL,
                `max_wait` INT(11) DEFAULT NULL,
                `next_retry` INT(11) DEFAULT NULL,
                INDEX(id_order),
                INDEX(id_cart),
                INDEX(id_shop),
                INDEX(is_sandbox),
                INDEX(`status`),
                INDEX(order_reference),
                INDEX(max_wait),
                INDEX(next_retry),
                INDEX(next_retry, status)
                )');

        $db_created = $db_created && Db::getInstance()->Execute('CREATE TABLE IF NOT EXISTS
                        `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache` (
                    `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                    `cache_id` varchar(100) NOT NULL,
                    `data` LONGTEXT NOT NULL,
                    `ttl` INT(11) NOT NULL,
                    UNIQUE(cache_id),
                    INDEX(ttl)
                    )');
        return $db_created;
    }
    public function uninstall()
    {
        if ((int)$this->os_wait_payment > 0) {
            $order_state = new OrderState((int)$this->os_wait_payment);
            @unlink(dirname(__FILE__).'/../../img/os/'.(int)$order_state->id.'.gif');
            $order_state->delete();
        }
        
        Configuration::deleteByName($this->module_name.'ksk_config');
        Configuration::deleteByName($this->module_name.'kijam_os_wait_payment');
        Configuration::deleteByName($this->module_name.'kijam_currency_convert');
        Db::getInstance()->Execute('DROP TABLE IF EXISTS `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`');
    }
    public function getConfig()
    {
        return $this->config;
    }
    public function getSettings()
    {
        return $this->settings;
    }
    public function verifyOrderWaitStatus()
    {
        if ((int)$this->os_wait_payment > 0) {
            $order_state = new OrderState((int)$this->os_wait_payment);
            if ($order_state && (int)$order_state->id > 0 && !$order_state->deleted) {
                return;
            }
        }

        $order_state = new OrderState();
        $order_state->name = array();
        foreach (Language::getLanguages() as $language) {
            $order_state->name[$language['id_lang']] = 'Esperando Pago';
        }

        $order_state->send_email = false;
        $order_state->color = '#DDEEFF';
        $order_state->hidden = false;
        $order_state->delivery = false;
        $order_state->logable = false;
        if (version_compare(_PS_VERSION_, '1.5.0.1') > 0) {
            $order_state->paid = false;
        }
        $order_state->invoice = false;
        if ($order_state->add()) {
            $source = dirname(__FILE__).'/view/img/state_ms_2.gif';
            $destination = dirname(__FILE__).'/../../img/os/'.(int)$order_state->id.'.gif';
            @copy($source, $destination);
        }
        $this->os_wait_payment = (int)$order_state->id;
        Configuration::updateValue($this->module_name.'kijam_os_wait_payment', $this->os_wait_payment);
        if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
            $shops = Shop::getCompleteListOfShopsID();
            $shop_groups_list = array();

            /* Setup each shop */
            foreach ($shops as $shop_id) {
                $shop_group_id = (int)Shop::getGroupFromShop($shop_id, true);

                if (!in_array($shop_group_id, $shop_groups_list)) {
                    $shop_groups_list[] = $shop_group_id;
                }
                /* Sets up configuration */
                Configuration::updateValue(
                    $this->module_name.'kijam_os_wait_payment',
                    $this->os_wait_payment,
                    false,
                    $shop_group_id,
                    $shop_id
                );
            }

            /* Sets up Shop Group configuration */
            if (count($shop_groups_list)) {
                foreach ($shop_groups_list as $shop_group_id) {
                    Configuration::updateValue(
                        $this->module_name.'kijam_os_wait_payment',
                        $this->os_wait_payment,
                        false,
                        $shop_group_id
                    );
                }
            }
        }
    }
    public function verifyKueski($force_reload = false)
    {
        if (!isset($this->config['client_secret']) || !isset($this->config['client_secret'])) {
            return false;
        }
        if (!$force_reload && !is_null($this->api_me)) {
            return $this->api_me;
        }
        $cache_id = 'mp_me_'.md5($this->config['client_id'].'-'.$this->config['client_secret']);
        $me = false;
        if (!$force_reload && $me = self::getCache($cache_id)) {
            if (isset($me['status'])) {
                if ($me['status'] == 'fail') {
                    self::log('ERROR-verifyKueski: '.self::pL($me, true));
                    return false;
                } else {
                    $this->api_me = $me;
                    return true;
                }
            }
        }
        try {
            if (!is_null($this->api)) {
                $me = $this->api->isApiKeyValid();
                self::setCache($cache_id, $me, 5);
                if (!$me || !isset($me['status']) || $me['status'] == 'fail') {
                    self::log('ERROR-verifyKueski: '.self::pL($me, true));
                    return false;
                }
                self::log('verifyKueski: new cache '.$cache_id.' -> '.self::pL($me, true));
                $this->api_me = $me;
                return $me;
            }
        } catch (Exception $e) {
            self::log('ERROR-verifyKueski: '.$e->getFile()."[".$e->getLine()."] -> ".$e->getMessage());
            return false;
        }
        return false;
    }
    public function hookDisplayAdminOrder($params, $file_template)
    {
        $order_id = (int)$params['id_order'];
        $valid = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                        SELECT * FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        WHERE `id_order` = '.(int)$order_id);

        self::log('hookDisplayAdminOrder-valid: '.self::pL($valid, true));

        if (isset($valid[0])) {
            $valid = $valid[0];
        }
        if (!$valid || !isset($valid['order_reference']) || empty($valid['order_reference'])) {
            return false;
        }
        $order = new Order($params['id_order']);
        $order_state = new OrderState($valid['status']);
        return array(
            'order_id' => $order_id,
            'ksk_data' => $valid,
            'mp_last_sync' => date('Y-m-d H:i:s', $valid['next_retry']),
            'mp_status' => $order_state->name[$this->context->language->id],
            'backwardcompatible' => _PS_VERSION_ < '1.6'
        );
    }
    public function hookOrderConfirmation($order)
    {
        $status_act = $order->getCurrentState();
        switch ($status_act) {
            case $this->config['os_authorization']:
            case Configuration::get('PS_OS_PREPARATION'):
            case Configuration::get('PS_OS_SHIPPING'):
                $result = array('status' => 'ok', 'show_modal' => false, 'id_order' => $order->id);
                break;
            case $this->os_wait_payment:
            case Configuration::get('PS_OS_OUTOFSTOCK'):
            case Configuration::get('PS_OS_OUTOFSTOCK_UNPAID'):
                $result = array('status' => 'pending', 'show_modal' => false, 'id_order' => $order->id);
                if (Tools::isSubmit('show_modal')) {
                    $result['show_modal'] = Tools::getValue('show_modal');
                }
                break;
            default:
                $result = array('show_modal' => false, 'status' => 'failed');
                break;
        }
        $result['shop_name'] = '';
        return $result;
    }
    public function hookDisplayPDFInvoice($params) {
        $order_invoice = $params['object'];
        $order = new Order((int)$order_invoice->id_order);
        $valid = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                        SELECT * FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        WHERE `id_order` = '.(int)$order->id);

        if (isset($valid[0])) {
            $valid = $valid[0];
        }
        if (!$valid || !isset($valid['order_reference'])) {
            return '';
        }
        return '<b>Kueski ID</b> '.$valid['order_reference'];
    }
    public function cronjob($smarty, $file_template)
    {
        if (is_null($this->api)) {
            return;
        }
        self::log('cronjob init');
        $valid = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                        SELECT id, id_cart, max_wait FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                        WHERE `next_retry` < '.(int)(time() - 2 * 60 * 60).' AND
                        (`status` = '.(int)$this->os_wait_payment.') ORDER BY id_cart ASC LIMIT 3');
        
        self::log('cronjob: checking: '.print_r($valid, true));
        foreach ($valid as $row) {
            $id_order = (int)Order::getOrderByCartId($row['id_cart']);
            $order = new Order($id_order);
            if ($order->getCurrentState() == $this->os_wait_payment) {
                if ($row['max_wait'] < time()) {
                    $order->setCurrentState((int)$this->config['os_refused']);
                }
            }
            Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'`
                SET
                    `next_retry` = '.(int)(time()).',
                    `status` = '.(int)$order->getCurrentState().'
                WHERE id = '.(int)$row['id']);
        }
        return $this->instance_module->display($file_template, 'views/templates/hook/cronjob.tpl');
    }
    public function hookUpdateOrderStatus($params)
    {
        if (!$this->api || self::$ignore_update_status) {
            return '';
        }
        return '';
    }
    public static function redirectUrl($url, $base_uri = __PS_BASE_URI__, Link $link = null)
    {
        if (!$link) {
            $link = Context::getContext()->link;
        }
        if (strpos($url, 'http://') === false && strpos($url, 'https://') === false && $link) {
            if (strpos($url, $base_uri) === 0) {
                $url = Tools::substr($url, Tools::strlen($base_uri));
            }
            if (strpos($url, 'index.php?controller=') !== false && strpos($url, 'index.php/') == 0) {
                $url = Tools::substr($url, Tools::strlen('index.php?controller='));
                if (Configuration::get('PS_REWRITING_SETTINGS')) {
                    $url = Tools::strReplaceFirst('&', '?', $url);
                }
            }
            $explode = explode('?', $url);
            // don't use ssl if url is home page
            // used when logout for example
            $use_ssl = !empty($url);
            $url = $link->getPageLink($explode[0], $use_ssl);
            if (isset($explode[1])) {
                $url .= '?'.$explode[1];
            }
        }
        return $url;
    }
    private function urlExists($file)
    {
        $file_headers = @get_headers($file);
        if (is_array($file_headers) && preg_match("/^HTTP.+\s(\d\d\d)\s/", $file_headers[0], $m) && isset($m[1])) {
            return (int)$m[1] >= 200 && (int)$m[1] < 300;
        } else {
            return false;
        }
    }
    public function paymentButton16($params, $context)
    {
        $create_order = Context::getContext()->link->getModuleLink($this->module_name, 'redirect', array(
            'createOrder' => '1'
        ));
        return array(
            'init_point' => $create_order,
            'mini_logo' => $this->site_url.'modules/'.$this->module_name.'/views/img/Kueski Pay_logo.svg'
        );
    }
    public function paymentButton17($params, $context)
    {
        if (!class_exists('PaymentOptionKueski')) {
            include_once(dirname(__FILE__).'/paymentoption.php');
        }
        $newOption = PaymentOptionKueski::getInstance();
        $cart = Context::getContext()->cart;
        try {
            $totals = $this->getCartOrderTotal($cart);
            $result = array(
                'config' => $this->config,
                'mini_logo' => $this->site_url.'modules/'.$this->module_name.'/views/img/Kueski Pay_logo.svg'
            );
            if (!$this->api_me || 
                $totals['both'] < $this->api_me['data']['merchant_limits']['min_amount'] || 
                $totals['both'] > $this->api_me['data']['merchant_limits']['max_amount']) {
                    return array();
            }
            $tpl = '/views/templates/hook/mp17Cart.tpl';
            Context::getContext()->smarty->assign($result);
            $create_order = Context::getContext()->link->getModuleLink($this->module_name, 'redirect', array(
                'createOrder' => '1'
            ));
            $newOption->setCallToActionText($this->l('Compra ahora, paga después'))
                        ->setAction($create_order)
                        ->setLogo(Media::getMediaPath('https://cdn.kueskipay.com/v1/img/mini_logo.png'))
                        ->setAdditionalInformation(
                            Context::getContext()->smarty->fetch(
                                'module:'.$this->module_name.$tpl
                            )
                        );
            $payment_options = array(
                $newOption,
            );
            return $payment_options;
        } catch (Exception $e) {
            $newOption->setCallToActionText($this->l('Kueski Pay'))
                        ->setAdditionalInformation(
                            $e->getFile().'['.$e->getLine().']: '.$e->getMessage()
                        );
            $payment_options = array(
                $newOption,
            );
            return $payment_options;
        }
    }
    /*******************************************************/
    /*******************************************************/
    /******** DESDE AQUI VA TODO LO RELACIONADO ************/
    /************* AL ADMIN DE PRESTASHOP ******************/
    /*******************************************************/
    /*******************************************************/
    public function hookBackOfficeHeader($params, $smarty, $file_template)
    {
        $ps_version = 1.6;
        if (version_compare(_PS_VERSION_, '1.6') < 0) {
            $ps_version = 1.5;
        }
        if (version_compare(_PS_VERSION_, '1.7.0.0') >= 0) {
            $ps_version = 1.7;
        }
        $smarty->assign('ps_version', $ps_version);
        $smarty->assign('new_ps_version', version_compare(_PS_VERSION_, '1.5.0.0') >= 0);
        return $this->instance_module->display($file_template, 'views/templates/admin/header.tpl');
    }
    private function updateConfig($file_template)
    {
        $errors = '';
        if (Tools::isSubmit('client_id') && Tools::isSubmit('client_secret')) {
            $ui_error = $this->instance_module->display($file_template, 'views/templates/admin/errors.tpl');
            Db::getInstance()->Execute('DELETE FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`');
            $reload_api = true;
            if (!isset($this->config['client_id'])
                || $this->config['client_id'] != trim(Tools::getValue('client_id'))) {
                $reload_api = true;
            }
            if (!isset($this->config['client_secret'])
                || $this->config['client_secret'] != trim(Tools::getValue('client_secret'))) {
                $reload_api = true;
            }
            $this->config['client_id'] = trim(Tools::getValue('client_id'));
            $this->config['client_secret'] = trim(Tools::getValue('client_secret'));
            $this->config['debug'] = (bool)Tools::getValue('debug');
            $this->config['style'] = (array)Tools::getValue('style');
            $this->config['os_authorization'] = (int)Tools::getValue('os_authorization');
            $this->config['os_refused'] = (int)Tools::getValue('os_refused');
            $this->config['modal'] = (bool)Tools::getValue('modal');
            $this->config['sandbox'] = (bool)Tools::getValue('sandbox');
            if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
                Configuration::updateValue(
                    $this->module_name.'ksk_config',
                    Tools::jsonEncode($this->config),
                    false,
                    $this->id_shop_group,
                    $this->id_shop
                );
            } else {
                Configuration::updateValue($this->module_name.'ksk_config', Tools::jsonEncode($this->config));
            }
            if ($reload_api) {
                if (version_compare(_PS_VERSION_, '1.5.1.0') >= 0) {
                    $id_country = Country::getByIso($this->settings['ISO']);
                    Country::addModuleRestrictions(
                        array(),
                        array(array('id_country'=>$id_country)),
                        array(array('id_module'=>$this->instance_module->id))
                    );
                }
                $this->verifyKueski(true);
                if (!$this->api_me) {
                    $errors .= sprintf($ui_error, $this->l('Your client_id or client_secret invalid.'));
                }
            }
        }
        return $errors;
    }

    public function adminPage($smarty, $file_template)
    {
        if (defined('PHP_SESSION_NONE') && session_id() == PHP_SESSION_NONE || session_id() == '') {
            session_start();
        }
        $ps_version = 1.6;
        if (version_compare(_PS_VERSION_, '1.6') < 0) {
            $ps_version = 1.5;
        }
        if (version_compare(_PS_VERSION_, '1.7.0.0') >= 0) {
            $ps_version = 1.7;
        }
        $smarty->assign('ps_version', $ps_version);
        $smarty->assign('riot_compiler_url', $this->instance_module->getPathTemplate().'views/js/riot.compiler.min.js');
        $ui_alerts = $this->instance_module->display($file_template, 'views/templates/admin/prestui/ps-alert.tpl');
        $ui_riot   = $this->instance_module->display($file_template, 'views/templates/admin/libs.tpl');
        $b64_riot   = $this->instance_module->display($file_template, 'views/templates/admin/b64_riot.tpl');
        if (version_compare(_PS_VERSION_, '1.5.0.9') >= 0) {
            $str = $this->getWarningMultishopHtml($file_template);
            if ((bool)Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')
                && (Shop::getContext() == Shop::CONTEXT_GROUP
            || Shop::getContext() == Shop::CONTEXT_ALL)) {
                $html = htmlentities($str.$this->getShopContextError($file_template));
                return sprintf($b64_riot, $html.$ui_alerts).$ui_riot;
            }
        }
        $str = $this->updateConfig($file_template);
        $order_states = OrderState::getOrderStates($this->context->employee->id_lang);

        if (!isset($this->config['os_authorization'])) {
            $this->config['os_authorization'] = (int)Configuration::get('PS_OS_PAYMENT');
            $this->config['os_refused'] = (int)Configuration::get('PS_OS_ERROR');
            $this->config['sandbox'] = false;
        }
        if (!isset($this->config['style'])
            || !isset($this->config['style']['b_size'])
            || empty($this->config['style']['b_size'])) {
            $this->config['style'] = array(
                'b_size' => 'medium',
            );
        }
        $return_url = Context::getContext()->link->getModuleLink($this->module_name, 'redirect');
        $groups = Group::getGroups(Context::getContext()->language->id);
        $smarty->assign($this->config);
        $smarty->assign('settings', $this->settings);
        $smarty->assign('display_name', $this->instance_module->displayName);
        $smarty->assign('api_me', $this->verifyKueski(true));
        $smarty->assign('log_path', '/modules/'.$this->module_name.'/logs/');
        $smarty->assign('order_states', $order_states);
        $smarty->assign('client_groups', $groups);
        $smarty->assign('return_url', $return_url);
        $smarty->assign('log_path_url', $this->site_url.'modules/'.$this->module_name.'/logs/index.php?token='.
            md5($_SERVER['HTTP_HOST'].gmdate('Ymd').session_id()));
        $html = $this->instance_module->display($file_template, 'views/templates/admin/config.tpl');
        $ui_form = $this->instance_module->display($file_template, 'views/templates/admin/prestui/ps-form.tpl');
        $ui_panel = $this->instance_module->display($file_template, 'views/templates/admin/prestui/ps-panel.tpl');

        return sprintf($b64_riot, htmlentities($str.$html).$ui_panel.$ui_form.$ui_alerts).$ui_riot;
    }

    /*******************************************************/
    /*******************************************************/
    /******** DESDE AQUI VA TODO LO RELACIONADO ************/
    /************ HERRAMIENTAS Y UTILIDADES ****************/
    /*******************************************************/
    /*******************************************************/
    public static function log($data)
    {
        if (!is_null(self::$instance)) {
            if (isset(self::$instance->config['debug']) && !self::$instance->config['debug']) {
                return;
            }
        } else {
            return;
        }
        if (!is_dir(dirname(__FILE__).'/logs')) {
            @mkdir(dirname(__FILE__).'/logs');
        }

        if (!is_dir(dirname(__FILE__).'/logs/'.date('Y-m'))) {
            @mkdir(dirname(__FILE__).'/logs/'.date('Y-m'));
        }

        $fp = fopen(dirname(__FILE__).'/logs/'.date('Y-m').'/log-'.date('Y-m-d').'.log', 'a');

        fwrite($fp, "\n----- ".date('Y-m-d H:i:s')." -----\n");
        fwrite($fp, $data);
        fclose($fp);
    }
    public static function pL(&$data, $return_log = true)
    {
        if (self::$instance == null) {
            return print_r($data, $return_log);
        }
        if (isset(self::$instance->config['debug']) && !self::$instance->config['debug']) {
            return '';
        }
        return print_r($data, $return_log);
    }
    public function l($key)
    {
        if ($this->instance_module) {
            return $this->instance_module->lang($key, 'kueski_gateway');
        }
        return $key;
    }
    public function getRate($from, $to)
    {
        $from = Tools::strtoupper($from);
        $to = Tools::strtoupper($to);

        if ($from == $to) {
            return 1.0;
        }
        $id_from = Currency::getIdByIsoCode($from);
        $id_to = Currency::getIdByIsoCode($to);
        if ($id_from * $id_to > 0) {
            $currency_from = new Currency((int)$id_from);
            $currency_to = new Currency((int)$id_to);
            $result = $currency_to->conversion_rate / $currency_from->conversion_rate;
            if ($result > 0.0) {
                self::log(
                    "getRate($from -> $to) ==> from ps: 
                    {$currency_to->conversion_rate} / {$currency_from->conversion_rate} = {$result}"
                );
                return (float)$result;
            }
        }
        self::log(
            "getRate($from -> $to) ==> not found, return 1.0"
        );
        return 1.0;
    }
    public static function getCache($cache_id)
    {
        if (self::$instance && self::$instance->api_me) {
            $cache_id .= self::$instance->config['client_id'];
        }
        $data = false;
        if (isset(self::$mp_cache[$cache_id]) && ($data = self::$mp_cache[$cache_id])) {
            return $data;
        }
        if (defined('_PS_CACHE_ENABLED_') && _PS_CACHE_ENABLED_) {
            $cache = Cache::getInstance();
            if ($data = $cache->get($cache_id)) {
                return $data;
            }
        }
        try {
            Db::getInstance()->Execute('DELETE FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`
                    WHERE ttl < '.(int)time());
            $d = Db::getInstance()->getValue('SELECT `data` FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`
                    WHERE `cache_id` = \''.pSQL($cache_id).'\'');
        } catch (PrestaShopDatabaseException $e) {
            return false;
        }
        if ($d) {
            $data = unserialize($d);
        }
        return $data;
    }
    public static function setCache($cache_id, $value, $ttl = 600)
    {
        if (self::$instance && self::$instance->api_me) {
            $cache_id .= self::$instance->config['client_id'];
        }
        self::$mp_cache[$cache_id] = $value;
        if (defined('_PS_CACHE_ENABLED_') && _PS_CACHE_ENABLED_) {
            $cache = Cache::getInstance();
            if ($cache->set($cache_id, $value, $ttl)) {
                return true;
            }
        }
        try {
            Db::getInstance()->Execute('DELETE FROM `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`
                    WHERE ttl < '.(int)time().' OR cache_id = \''.pSQL($cache_id).'\'');
            return Db::getInstance()->Execute('INSERT IGNORE INTO `'.bqSQL(_DB_PREFIX_.self::DB_PREFIX).'_cache`
                        (`cache_id`, `data`, `ttl`) VALUES
                        (\''.pSQL($cache_id).'\',
                         \''.pSQL(serialize($value)).'\',
                         '.(int)(time() + $ttl).')');
        } catch (PrestaShopDatabaseException $e) {
            return false;
        }
    }
    protected function getWarningMultishopHtml($file_template)
    {
        if ((bool)Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')
            && (Shop::getContext() == Shop::CONTEXT_GROUP
            || Shop::getContext() == Shop::CONTEXT_ALL)) {
            $ui_warning = $this->instance_module->display($file_template, 'views/templates/admin/alerts.tpl');
            return sprintf(
                $ui_warning,
                'warning',
                $this->l('You cannot change setting from a "All Shops" or a "Group Shop" context, '.
                         'select directly the shop you want to edit')
            );
        } else {
            return '';
        }
    }
    protected function getShopContextError($file_template)
    {
        $ui_warning = $this->instance_module->display($file_template, 'views/templates/admin/alerts.tpl');
        return sprintf(
            $ui_warning,
            'danger',
            sprintf($this->l('You cannot edit setting from a "All Shops" or a "Group Shop" context'))
        );
    }
}
