<?php

class KueskiLib
{
    const URL_PRODUCTION = "https://api.kueskipay.com/";
    const URL_SANDBOX = "https://testing.kueskipay.com/";

    /**
     * @var bool
     */
    private $sandbox;
    
    /**
     * @var string
     */
    private $apiKey;
    /**
     * @var string
     */
    private $kpName;

    /**
     * @var string
     */
    private $kpVersion;

    /**
     * @var string
     */
    private $kpTrigger;

    /**
     * @var string
     */
    private $kpSource;
    
    /**
     * @var string
     */
    private $apiSecret;

    /**
     * KueskiLib constructor.
     * @param string $apiKey
     * @param $kpName
     * @param $kpVersion
     * @param $kpTrigger
     * @param $kpSource
     * @param bool $sandbox
     */
    public function __construct(
        $apiKey,
        $apiSecret,
        $kpName,
        $kpVersion,
        $kpTrigger,
        $kpSource,
        $sandbox = false
    )
    {
        $this->apiKey = $apiKey;
        $this->apiSecret = $apiSecret;
        $this->sandbox = $sandbox;
        $this->kpName = $kpName;
        $this->kpVersion = $kpVersion;
        $this->kpTrigger = $kpTrigger;
        $this->kpSource = $kpSource;
    }

    /**
     * @return string
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    
    /**
     * @return string
     */
    public function getApiSecret()
    {
        return $this->apiSecret;
    }

    /**
     * @return bool
     */
    public function isSandbox()
    {
        return $this->sandbox;
    }

    /**
     * @return string
     */
    public function getUrl() {
        if ($this->isSandbox()) {
            return self::URL_SANDBOX;
        } else {
            return self::URL_PRODUCTION;
        }
    }

    public function isApiKeyValid() {
        $ch = curl_init();

        $url = $this->getUrl() . "v1/validate-keys?api_key=" . $this->getApiKey();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 0);
        $result = curl_exec($ch);
        curl_close($ch);

        if (!$result) {
            return false;
        }

        return json_decode($result, true);
    }
    public function createOrder($arr_order) {
        $ch = curl_init();

        $post = json_encode($arr_order);
        $header = array();

        $header[] = "Authorization: Bearer " . $this->getApiKey();
        $header[] = 'Content-length: ' . strlen($post);
        $header[] = 'Content-type: application/json';
        $header[] = 'kp-name: ' . $this->kpName;
        $header[] = 'kp-version: ' . $this->kpVersion;
        $header[] = 'kp-source: ' . $this->kpSource;
        $header[] = 'kp-trigger: ' . $this->kpTrigger;
        curl_setopt($ch, CURLOPT_URL, $this->getUrl() . "v1/payments");
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        //curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        $result = curl_exec($ch);
        curl_close($ch);
        if (!$result) {
            return false;
        }
        $result = json_decode($result);
        if ($result->status == "fail" || $result->status == "error") {
            throw new \Exception($result->message);
        }

        return array('url' => $result->data->callback_url, 'data' => $result->data);
    }

    public function confirmWebhook($data) {
        $post = json_encode($data);
        $header = array();
        header_remove();
        header("Authorization: Bearer " . $this->getApiSecret());
        header('Content-length: ' . strlen($post));
        header('Content-type: application/json');
        header('kp-name: ' . $this->kpName);
        header('kp-version: ' . $this->kpVersion);
        header('kp-source: ' . $this->kpSource);
        header('kp-trigger: ' . $this->kpTrigger);
        echo $post;
        exit;
    }
}